#include "xml_serializers.h"


using namespace aka2;

#include "../../transcoders/builtin_transcoders.h"

utf8_serializer::utf8_serializer()
  : xml_serializer("UTF-8", &default_transcoder::create) {
}

#ifdef AKAXISO2_USE_ICU

#include "../../transcoders/icu_transcoder.h"

icu_serializer::icu_serializer(const std::string &encoding)
  : xml_serializer(encoding, &icu_transcoder::create) { }

#endif


#ifdef AKAXISO2_USE_ICONV

#include "../../transcoders/iconv_transcoder.h"

iconv_serializer::iconv_serializer(const std::string &encoding)
  : xml_serializer(encoding, &iconv_transcoder::create) { }

#endif

#ifdef _WIN32

#include "../../transcoders/win32_transcoder.h"

win32_serializer::win32_serializer(const std::string &encoding) 
  : xml_serializer(encoding, &win32_encodings::create) { }

#endif
