/* -*- c++ -*- */
#ifndef AKAXISO2_AKAXISO2_H__
#define AKAXISO2_AKAXISO2_H__

/**
 * @file akaxiso2/akaxiso2.h
 * @brief Akaxiso library initializer/uninitializer
 */

#include <akaxiso2/configuration.h>
#include <akaxiso2/framework/namespaces.h>
#include <akaxiso2/framework/any.h>
#include <akaxiso2/builtin/builtin.h>
#include <akaxiso2/builtin/schema_builtin.h>

#include <akaxiso2/transcoders/pivot_transcoder.h>
#include <akaxiso2/transcoders/builtin_transcoders.h>

#include <akaxiso2/XML/serializer/xml_serializers.h>
#include <akaxiso2/XML/deserializer/xml_deserializers.h>



namespace aka2 {

  extern const char akaxiso2_ns_uri[];
  extern const char xmlschema_ns_uri[];

  void set_default_encoding(const std::string &encoding);

  /**
   * @brief Initializer of akaxiso library.
   *
   * Initialize akaxiso library.\n
   * xercesc::XMLPlatformUtils::Initialize() is called if you enable Xerces-C++.
   */
  int initialize();
  
  /** 
   * @brief Uninitializer of akaxiso library.
   *
   * Release system resources.\n
   * xercesc::XMLPlatformUtils::Terminate() will be called if you enable Xerces-C++. 
   */
  void uninitialize();

  const char *version();
  const char *compiler();
  const char *default_parser_name();
  const char *default_transcoder_name();

}

#endif /* AKAXISO2_AKAXISO2_H__ */
