/* -*- c++ -*- */
#ifndef AKAXISO2_BUILTIN_XISO_H__
#define AKAXISO2_BUILTIN_XISO_H__

/**
 * @file akaxiso2/builtin/builtin_xiso.h
 * @brief leaf classes for akaxiso2 builtins.
 */

#include <akaxiso2/configuration.h>
#include <akaxiso2/util/iosfwd.h>
#include <akaxiso2/framework/simpletype.h>
#include <akaxiso2/framework/array.h>
#include <akaxiso2/builtin/builtin.h>

namespace aka2 {

  void initialize_builtins();

  /**
   * builtin types.
   *
   * char, unsigned char,
   * short, unsigned short,
   * long unsigned long,
   * LONGLONG, ULONGLONG,
   * int, unsigned int,
   * bool,
   * float, double, std::string,
   * nill.
   */

  /** leaf for builtin arrays. */
  typedef aka2::sequential_array<std::vector<char> >           char_array_leaf;
  typedef aka2::sequential_array<std::vector<unsigned char> >  uchar_array_leaf;
  typedef aka2::sequential_array<std::vector<short> >          short_array_leaf;
  typedef aka2::sequential_array<std::vector<unsigned short> > ushort_array_leaf;
  typedef aka2::sequential_array<std::vector<long> >           long_array_leaf;
  typedef aka2::sequential_array<std::vector<unsigned long> >  ulong_array_leaf;
  typedef aka2::sequential_array<std::vector<LONGLONG> >       longlong_array_leaf;
  typedef aka2::sequential_array<std::vector<ULONGLONG> >      ulonglong_array_leaf;
  typedef aka2::sequential_array<std::vector<int> >            int_array_leaf;
  typedef aka2::sequential_array<std::vector<unsigned int> >   uint_array_leaf;
  typedef aka2::sequential_array<std::vector<bool> >           bool_array_leaf;
  typedef aka2::sequential_array<std::vector<float> >          float_array_leaf;
  typedef aka2::sequential_array<std::vector<double> >         double_array_leaf;
  typedef aka2::sequential_array<std::vector<std::string> >    string_array_leaf;
  typedef aka2::sequential_array<std::vector<aka2::nill> >     nill_array_leaf;


  /**
   * @brief leaf class for nill value.
   *
   * Use aka2::nill for no-value element.
   */
  struct  nill_leaf :  public aka2::simpletype<nill, nill_leaf>  {
    void model();
    static void initialize() {}
    static void uninitialize() {}
    static bool equals(const void *, const void *) {
      return true;
    }
    /** @brief nothing to write. */
    static void write_text(const void *e, std::ostream &ostm, entity_complements &pcd) { }
    /** @brief nothing to read. */
    static void read_text(void *e, const std::string &entity, entity_complements &pcd) { }
    static default_op* create_default_op() { return 0; }
  };

}

namespace xiso {

  template<> 
  struct leaf<char> : public aka2::simpletype<char> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
    static void write_text(const void *elm, std::ostream &ostm, aka2::entity_complements &ecomps);
  };

  template<> 
  struct leaf<unsigned char> : public aka2::simpletype<unsigned char> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
    static void write_text(const void *elm, std::ostream &ostm, aka2::entity_complements &ecomps);
  };


  template<> 
  struct leaf<short>  : public aka2::simpletype<short>  {
    void model();
  };

  template<> 
  struct leaf<unsigned short>  : public aka2::simpletype<unsigned short>  {
    void model();
  };


  template<> 
  struct leaf<long>   : public aka2::simpletype<long> {
    void model();
  };

  template<> 
  struct leaf<unsigned long>   : public aka2::simpletype<unsigned long> {
    void model();
  };

  template<> 
  struct leaf<LONGLONG>   : public aka2::simpletype<LONGLONG>   {
    void model();
    static void write_text(const void *elm, std::ostream &ostm, aka2::entity_complements &ecomps);
  };

  template<> 
  struct leaf<ULONGLONG>   : public aka2::simpletype<ULONGLONG>   {
    void model();
    static void write_text(const void *elm, std::ostream &ostm, aka2::entity_complements &ecomps);
  };

  template<> 
  struct leaf<int>    : public aka2::simpletype<int> {
    void model();
  };

  template<> 
  struct leaf<unsigned int>    : public aka2::simpletype<unsigned int> {
    void model();
  };


  template<>
  struct leaf<bool> : public aka2::simpletype<bool> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity,
				  aka2::entity_complements &ecomps);
    static void write_text(const void *elm, std::ostream &ostm,
			   aka2::entity_complements &ecomps);
  };
  
  
  template<> 
  struct leaf<float>  : public aka2::simpletype<float> {
    void model();
  };

  template<> 
  struct leaf<double> : public aka2::simpletype<double> {
    void model();
  };

  template<>
  struct leaf<std::string> : public aka2::simpletype<std::string> {
    void model();
    static void read_unicode_text(void *elm, const aka2::pstring &entity, 
				  aka2::entity_complements &ecomps);
  };
  
  
  template<> struct leaf<aka2::nill> : public aka2::nill_leaf {
    void model();
  };



} // namespace xiso


#endif
