/* -*- c++ -*- */
#ifndef AKAXISO2_UTIL_MUTEX_WIN32_H__
#define AKAXISO2_UTIL_MUTEX_WIN32_H__

#include <akaxiso2/configuration.h>

#if defined(_WIN32) && defined(AKAXISO2_MULTITHREADED)

#include <winbase.h>

namespace aka2 {

  /** @brief WIN32 mutex */
  class mutex_win32 {
  public:
    /** default constructor to create WIN32's ciritcal section */
    mutex_win32();
    /** default constructor to free WIN32's ciritcal section */
    ~mutex_win32();
    /** lock */
    void lock();
    /** unlock */
    void unlock();
  private:
    CRITICAL_SECTION critical_section_;
  };

}  

#endif

#endif
