#include "fixed_handler.h"

using namespace aka2;

fixed_handler::fixed_handler(const qname& tagname, int depth, const member_type &mtype,
			     parser_context &context) 
  : handler(context, depth, tagname), mtype_(mtype) {
}

parse_result fixed_handler::query_element(const qname &tagname, const attribute_values &attrs, 
					  const global_attributes &gattrs) {
  assert(!"Must not be called.");
  return error;
}


bool fixed_handler::parse_entity(const std::string &entity, const global_attributes &gattrs) {
  return mtype_.is_fixed_string(entity);
}

parse_result fixed_handler::end_element(const qname &tagname) {
  return ok;
}

memberpair fixed_handler::get_element() {
  return mtype_.get_member(static_cast<void*>(0));
}

void fixed_handler::receive_child(const memberpair &e) {
  assert(!"Must not be called.");
}

bool fixed_handler::can_skip() {
  assert(!"Must not be called.");
  return false;
}

void fixed_handler::abort() {
}






fixed_array_handler::fixed_array_handler(const qname& tagname, int depth, const member_type &mtype,
					 parser_context &context) 
  : handler(context, depth, tagname), mtype_(mtype), count_(0) {
}

parse_result fixed_array_handler::query_element(const qname &tagname, 
						const attribute_values &attrs, 
						const global_attributes &gattrs) {
  if (tagname == tagname_) {
    create_fixed_handler(tagname, depth_, mtype_);
    return ok;
  }
  return skip;
}

bool fixed_array_handler::parse_entity(const std::string &entity, 
				       const global_attributes &gattrs) {
  return true;
}


void fixed_array_handler::receive_child(const memberpair &e) {
  ++count_;
}

bool fixed_array_handler::can_skip() {
  return mtype_.get_occurence().in_range(count_);
}

memberpair fixed_array_handler::get_element() {
  return mtype_.get_member(static_cast<void*>(0));
}

parse_result fixed_array_handler::end_element(const qname &tagname) {
  if (mtype_.get_occurence().in_range(count_))
    return ok;
  return error;
}

void fixed_array_handler::abort() {
}
