/* -*- c++ -*- */
#ifndef CDOM_SEQUENCE_HANDLER_H__
#define CDOM_SEQUENCE_HANDLER_H__

#include <akaxiso/parser/handler.h>
#include <akaxiso/classes/membertype.h>

namespace aka2 {

  class sequence_handler : public handler {
    friend class closure_handler;
  public:
    sequence_handler(const qname& tagname, void *seq, int depth,
		     const sequence_op& sop, 
		     parser_context &context);
    sequence_handler(const qname& tagname, sequence_handler *seqhandler, int depth);

    virtual ~sequence_handler(){}
    virtual parse_result query_element(const qname &tagname, const attribute_values &attrs, 
				       const global_attributes &gattrs);
    virtual parse_result end_element(const qname &tagname);
    virtual bool parse_entity(const std::string &entity, const global_attributes &gattrs);

    virtual memberpair get_element();
    virtual void receive_child(const memberpair &e);
    virtual bool can_skip();
    virtual void abort(){}
    
  private:
    parse_result parse_element(const qname &tagname, const attribute_values &attrs, 
			       const global_attributes &gattrs);
    parse_result find_particle(const qname &tagname, const attribute_values &attrs, 
			       const global_attributes &gattrs); 
   
    bool can_skip_member();


    void *seq_;
    const sequence_op &sop_;
    member_types::const_iterator itend_;
    member_types::const_iterator it_;
  };

}


#endif
