/* -*- c++ -*- */
#ifndef AKAXISO_ANY_H__
#define AKAXISO_ANY_H__

#include <akaxiso/classes/traits.h>
#include <akaxiso/classes/membertype.h>

#include <vector>

namespace aka2 {

  struct any {
    qname tagname_;
    attribute_values attributes_;
    std::string value_;
  };

  class any_op_dispatcher : public element_op {
  public:
    virtual schematype_id get_schematype() const { return any_id; }
    virtual const qname& get_typename() const { return typename_; }
    
    /** creatable */
    virtual void* create() const { return new any; }
    virtual void destroy(void *elm) const { delete static_cast<any*>(elm); }
    
    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const { 
      return 0; 
    }
    static qname typename_;
  };

};



#endif
