#include "item.h"
#include "traits.h"

using namespace aka2;

bool itemtype::equals(const void *lhs, const void *rhs) const {
  return op_->equals(lhs, rhs);
}


schematype_id itemtype::get_schematype() const {
  return op_->get_schematype();
}


const item& item::operator=(const item& rhs) {
  if ((this == &rhs) || (element() == rhs.element()))
    return *this;
  name_ = rhs.name_;
  element_ = rhs.element_;
  return *this;
}


bool aka2::item_of(const aka2::item &i, const std::string &tagname) {
  return aka2::qname(tagname) == i.get_name();
}
