#include "membertype.h"


using namespace aka2;

bool attribute_type::should_write(const void *elm) const {
  if (required_) // Required then always should be written.
    return true;
  if (is_default_specified() && is_member_default(elm)) // @default && !required.
    return false; // Don't have to be written
  return true;
}

memberpair named_member::get_member(void *e) const {
  void *mem = mgetter_->get_member(e);
  const element_op *eo = mgetter_->get_op();
  return memberpair(mem, *eo);
}

const_memberpair named_member::get_member(const void *element) const {
  const void *mem = mgetter_->get_member(element);
  const element_op *eo = mgetter_->get_op();
  return const_memberpair(mem, *eo);
}

bool named_member::equals(const void *lhs, const void *rhs) const {
  const_memberpair lhspair = get_member(lhs);
  const_memberpair rhspair = get_member(rhs);

  if (&lhspair.op_ != &rhspair.op_)
    throw internal_error();

  return lhspair.op_.equals(lhspair.e_, rhspair.e_);
}


void named_member::copy(void *dest, const void *src) const {
  memberpair destpair = get_member(dest);
  const_memberpair srcpair = get_member(src);

  if (&destpair.op_ != &srcpair.op_)
    throw internal_error();

  srcpair.op_.copy(destpair.e_, srcpair.e_);
}

