/* -*- c++ -*- */
#ifndef AKAXISO_TYPE_REGISTORY_H__
#define AKAXISO_TYPE_REGISTORY_H__


#include <akaxiso/classes/traits.h>

namespace aka2 {

  struct type_entry {
    typedef void (*uninitializer)();

    type_entry(element_op &op, uninitializer uni) 
      : op_(op), uninitializer_(uni), refcount_(0) {}

    element_op &op_; 
    uninitializer uninitializer_;
    int refcount_;
  };

  class type_registory {
    typedef std::map<const element_op*, type_entry> typemap;
    typemap types_;
  public:
    void initialize(){ remove_all(); }
    void uninitialize(){ remove_all(); }

    bool add(element_op &op, type_entry::uninitializer uni);

    void remove_all();

    template<class L>
    bool add(const L& l) {
      return add(L::dispatcher_, &L::uninitialize);
    }
  };

}




#endif

