// -*- c++ -*-
#ifndef AKAXISO_CHOICE_HANDLER_H__
#define AKAXISO_CHOICE_HANDLER_H__

#include <akaxiso/parser/handler.h>

namespace aka2 {
  
  class choice_handler : public handler {
  public:
    choice_handler(const qname &tagname, void *cho, int depth,
		   const choice_op &cop, const occurence &occ,
		   parser_context &context);
    virtual ~choice_handler(){}
    virtual parse_result query_element(const qname &tagname, const attribute_values &attrs, 
				       const global_attributes &gattrs);
    virtual parse_result end_element(const qname &tagname);
    virtual bool parse_entity(const std::string &entity, const global_attributes &gattrs);
    
    virtual memberpair get_element();
    virtual void receive_child(const memberpair &mpair);
    
    virtual bool can_skip();
    virtual void abort();
  private:
    parse_result parse_element(const attribute_values &attrs, 
			       const global_attributes &gattrs);
    parse_result find_particle(const qname &tagname, const attribute_values &attrs, 
			       const global_attributes &gattrs);
    void *cho_;
    void *e_;
    const choice_op &cop_;
    const occurence &occurence_;
    int count_;
    bool error_;
    itemtypes::const_iterator current_;
  };

}

#endif

