// -*- c++ -*-

#ifndef AKAXISO_SERIALIZER_H__
#define AKAXISO_SERIALIZER_H__


#include <akaxiso/classes/types.h>
#include <akaxiso/classes/document.h>

namespace aka2 {

  class serializer  {
  public:
    serializer(int tab);
    virtual ~serializer(){};

    void serialize(const document &doc, std::ostream &ostm);

    template<class R>
    void serialize(const R &root, const std::string &name, std::ostream &ostm) {
      const docdef *def = system_document_factory().get_docdef(name);
      if (def == 0)
	throw internal_error();
      serialize_internal(static_cast<const void*>(&root), name, *def->op_, ostm);
    }

  protected:
    virtual void serialize_internal(const void *root, const qname &name,
				    const element_op &op,
				    std::ostream &ostm) = 0;

    int indent_;
    void inc_indent_level() { ++indent_; }
    void dec_indent_level() { -- indent_; }
    void new_line(std::ostream &ostm);

    static bool is_sequence_empty(const void *e, const member_types &mtypes);
    static bool is_all_empty(const void *e, const member_map &mmap);
    static bool is_member_empty(const void *e, const member_type &mtype);

    std::string indent_str_;
  };
}

#endif  // ifdef AKAXISO_SERIALIZER
