// -*- c++ -*-
#ifndef AKAXISO_XERCES_PARSER_H__
#define AKAXISO_XERCES_PARSER_H__

#include <akaxiso/classes/document.h>
#include <akaxiso/parser.h>
#include <akaxiso/xerces/xerces_ns.h>

#ifdef USE_XERCESC
#include <xercesc/sax2/SAX2XMLReader.hpp>
#endif


namespace aka2 {


  class xerces_parser : public parser {
  public:
    xerces_parser();

#ifdef USE_XERCESC
    ~xerces_parser();
    virtual document parse(std::istream &istm);
    virtual document parse(const char *document);
    virtual document parse(const std::string &document);
    virtual document parse_stdin();
    virtual document parse_file(const std::string &filepath);
    void set_gattrs(global_attributes &gattrs);
  private:
    document parse(xercesc::InputSource &src, const std::string &source_name);
    xercesc::SAX2XMLReader *parser_;
    global_attributes *gattrs_;
#endif
  };

}

#endif
