// -*- c++ -*-
#ifndef AKAXISO_YGG_PARSER_H__
#define AKAXISO_YGG_PARSER_H__

#include <akaxiso/classes/document.h>
#include <akaxiso/parser.h>
#include <iosfwd>

namespace aka2 {

  class ygg_parser : public parser {
  public:
    ygg_parser() : gattrs_(0) {}
    virtual document parse(std::istream &istm);
    virtual document parse(const char *document);
    virtual document parse(const std::string &document);
    virtual document parse_stdin();
    virtual document parse_file(const std::string &filename);
    void set_gattrs(global_attributes &gattrs);
  protected:
    virtual document parse_internal(std::istream &stm, const std::string &source_name) = 0;
    global_attributes *gattrs_;
  };


  class yggsox_parser : public ygg_parser {
  public:
  protected:
    virtual document parse_internal(std::istream &stm, const std::string &source_name);
  };


  class yggxml_parser : public ygg_parser {
  public:
  protected:
    virtual document parse_internal(std::istream &stm, const std::string &source_name);
  };

}

#endif
