#include "model_array.h"
#include <akaxiso/akaxiso.h>
#include <stdlib.h>

void serialize() {

  root models;
  model m;
  m.test_ = "test1";
  models.models_.push_back(m);

  m.test_ = "test2";
  models.models_.push_back(m);

  aka::xml_serializer ser;
  ser.serialize(models, "model_arrays", std::cout);
}

void parse() {

  aka::xml_parser parser;

  aka::document doc;
  try {
    doc = parser.parse_stdin();
  }
  catch ( const std::exception &e) {
    std::cerr << e.what() << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Parse error detected." << std::endl;
    exit(1);
  }
  
  // Check root tagname to confirm the root class.
  if (!aka::document_of(doc, "model_arrays")) {
    std::cerr << "Unknown document(" << doc.get_name() << ")." << std::endl;
    exit(1);
  }

  aka::xml_serializer ser;
  ser.serialize(doc, std::cout);

}


void usage() {
  std::cout << "project [-s|-p|-h]" << std::endl
	    << "  -s : serialize." << std::endl
	    << "  -p : parse.    " << std::endl
	    << "  -h : show this usage." << std::endl;
}


int main(int argc, const char* argv[]){
  
  // Initialize Xerces.
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
#endif
  aka::initialize();
  aka::doctype("model_arrays", xiso::leaf<root>());

  if (argc != 2) {
    usage();
    return 1;
  }

  std::string arg = argv[1];

  if (arg == "-s")
    serialize();
  else if (arg == "-p")
    parse();
  else {
    usage();
    return 1;
  }

  aka::uninitialize();
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Terminate();
#endif
  return 0;
}
