/* -*- c++ -*- */
#ifndef AKAXISO_BUILTIN_H__
#define AKAXISO_BUILTIN_H__

#ifdef _MSC_VER
std::istream &operator>>(std::istream &istm, LONGLONG &value);
#endif


namespace xiso {

  template<> struct leaf<long> : public aka2::simpletype<long> {  };
  template<> struct leaf<int> : public aka2::simpletype<int> {  };
  template<> struct leaf<short> : public aka2::simpletype<short> {  };
  template<> struct leaf<float> : public aka2::simpletype<float> {  };
  template<> struct leaf<double> : public aka2::simpletype<double> {  };

  template<> 
  struct leaf<std::string> : public aka2::simpletype<std::string> {
  public:
    static void read_text(void *elm, std::istringstream &istm,
			  const aka2::global_attributes &gattrs) {
      std::string &value = *reinterpret_cast<std::string*>(elm);
      value = istm.rdbuf()->str();
    }
  };


  template<> 
  struct leaf<const std::string> : public aka2::simpletype<std::string> {
  public:
    static void read_text(void *elm, std::istringstream &istm,
			  const aka2::global_attributes &gattrs) {
      std::string &value = *reinterpret_cast<std::string*>(elm);
      value = istm.rdbuf()->str();
    }
  };

}

#endif


