/* -*- c++ -*- */
#ifndef AKAXISO_CONTAINER_METHODS_H__
#define AKAXISO_CONTAINER_METHODS_H__

#include <list>

namespace aka2 {
  class item;

  template<class C>
  struct sequential {
    typedef TYPENAME C::value_type V;
    V& push(C &c, const V &v) {
      c.push_back(v);
      return c.back();
    }
  };


  template<class C>
  struct associative {
    typedef TYPENAME C::value_type V;
    V& push(C &c, const V &v) {
      std::pair<TYPENAME C::iterator, bool> res = c.insert(v);
      if (!res.second)
	throw internal_error();
      return *res.first;
    }
  };


  // More containers. !!!!!!!!!!!!!!
}

#endif

