/* -*- c++ -*- */
#ifndef AKAXISO_MEMBERTYPE_H__
#define AKAXISO_MEMBERTYPE_H__

#include <akaxiso/classes/member.h>
#include <akaxiso/classes/traits.h>

#include <assert.h>

namespace aka2 {

  class member_type {
  public:
    member_type() : mgetter_(0), default_(0) {}
    member_type(const member_getter *getter) : mgetter_(getter), default_(0){}
    //~member_type() { delete mgetter_; } !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    
    void set_name(const std::string &name){ name_.set(name); }
    const qname &get_name() const  { return name_; } // !!!!!!!!!Should be included in constructor?

    memberpair get_member(void *e) const;
    const_memberpair get_member(const void *element) const;

    schematype_id get_schematype() const { 
      return mgetter_->get_op()->get_schematype(); 
    }

    void set_occurence(const occurence &occurs) {
      occurence_ = occurs;
    }

    const occurence& get_occurence() const {
      return occurence_;
    }

    bool equals(const void *lhs, const void *rhs) const ;
    void copy(void *dest, const void *src) const;

    /** Default-value-related methods */

    void set_default_op(default_op *defop) { 
      assert(defop != 0);
      default_ = defop; 
    }

    void set_default(const char *defval) { default_->set_default(defval); }

    bool has_default() const { 
      if (default_ == 0)
	return false;
      return default_->has_default(); 
    }

    void init_value(void *e) const {
      void *mem = mgetter_->get_member(e);
      default_->init_value(mem);
    }

    bool is_default(const void *e) const { 
      const void *mem = mgetter_->get_member(e);
      return default_->is_default(mem); 
    }

    bool is_element() const { return name_.local()[0] != '&'; }

  private:
    qname name_;
    const member_getter *mgetter_;
    default_op *default_;
    occurence occurence_;
  };



  enum attribute_use {
    required = 1,
    optional
    //fixed !!!!!!!!!!
  };
  
  class attribute_type : public member_type  {
  public:
    attribute_type() : use_(optional){}
    attribute_type(const member_getter *mgetter) : member_type(mgetter), use_(optional) {}
    void set_use(attribute_use use) { use_ = use; }
    attribute_use  get_use() const { return use_; }
    bool  should_write(const void *elm) const;
    attribute_use use_;    
  };

  struct member_types : public std::vector<member_type> {};
  struct member_map : public std::map<qname, member_type, qname_less> {};
  struct attribute_types : public std::map<qname, attribute_type, qname_less> {};

}

#endif
