#include "type_registory.h"

using namespace aka2;

bool type_registory::add(element_op &op, type_entry::uninitializer uni) {

  typemap::iterator it = types_.find(&op);
  if (it != types_.end())
    return false;

  type_entry te(op, uni);
  std::pair<typemap::iterator, bool> res = types_.insert(typemap::value_type(&op, te));
  assert(res.second);

  return true;
}

void type_registory::remove_all() {
  for (typemap::iterator it = types_.begin(); it != types_.end(); ++it) {
    type_entry &te = it->second;
    te.uninitializer_();
  }
  types_.clear();
}
