// -*- c++ -*-
#ifndef AKAXISO_TYPEDESC_H__
#define AKAXISO_TYPEDESC_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/namespaces.h>
#include <akaxiso/classes/qname.h>

namespace aka2 {

  class typeinfo {
  public:
    void set_name(const qname &name) { name_ = name; }
    const qname &get_qname() const { return name_; }
  private:
    qname name_;
  };

  inline bool operator==(const typeinfo& lhs, const typeinfo &rhs) {
    return &lhs == &rhs;
  }

  inline bool operator!=(const typeinfo& lhs, const typeinfo &rhs) {
    return &lhs != &rhs;
  }

  class internal_type : public typeinfo {
  public:
    internal_type() { set_name(qname("#internal_type")); }
  };
  static internal_type internal_typeinfo_;

}

#endif
