#include "all_test.h"

#include <akaxiso/akaxiso.h>

void serialize() {

  params root;
  root.one_ = "one";
  root.two_ = "two";
  root.three_ = 0;
  //  root.three_ = new std::string("three");

  aka::xml_serializer ser;
  ser.serialize(root, "params", std::cout);

}

void parse() {
  
  aka::xml_parser parser;

  aka::document doc;
  try {
    doc = parser.parse_stdin();
  }
  catch ( const std::exception &e) {
    std::cerr << e.what() << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Parse error detected." << std::endl;
    exit(1);
  }

  
  // Check root tagname to confirm the root class.
  if (!aka::document_of("params", doc)) {
    std::cerr << "Unknown document(" << doc.get_name() << ")." << std::endl;
    exit(1);
  }

  // Get the root node.
  params *root = aka::root_cast<params>(doc);
  std::cout << "Params:" << std::endl
	    << "one   : " << root->one_ << std::endl
	    << "two   : " << root->two_ << std::endl
	    << "three : ";
  if (root->three_ == 0)
    std::cout << "(null)" << std::endl;
  else
    std::cout << *root->three_ << std::endl;

}


void usage() {
  std::cout << "project [-s|-p|-h]" << std::endl
	    << "  -s : serialize." << std::endl
	    << "  -p : parse.    " << std::endl
	    << "  -h : show this usage." << std::endl;
}


int main(int argc, const char* argv[]){
  
  // Initialize Xerces.
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
#endif
  aka::initialize();

  aka::doctype("params", xiso::leaf<params>());

  if (argc != 2) {
    usage();
    return 1;
  }

  std::string arg = argv[1];

  if (arg == "-s")
    serialize();
  else if (arg == "-p")
    parse();
  else {
    usage();
    return 1;
  }

  aka::uninitialize();
#ifdef USE_XERCESC
  xercesc::XMLPlatformUtils::Terminate();
#endif
  return 0;
}
