// -*- c++ -*-
#ifndef AKAXISO_CHOICE_H__
#define AKAXISO_CHOICE_H__

#include <akaxiso/classes/itemtype.h>
#include <akaxiso/classes/element.h>
#include <akaxiso/classes/name.h>
#include <akaxiso/classes/attributeinfo.h>

#include <map>
#include <list>

#include <akaxiso/classes/elementlist.h>


namespace akaxiso {

  class item {
  public:
    item(element* e, const itemtype &itype) : 
      itemtype_(itype), element_(e) {}

    const name &get_qname() const;
    const std::string &get_tagname() const;

    element *get_element() {
      return element_;
    }
    const element *get_element() const {
      return element_;
    }
   const itemtype &get_itemtype() const {
      return itemtype_;
    }

  private:
    const itemtype &itemtype_;
    element *element_;
  };



  class choice_info;
  typedef elementlist_impl<element> elementlist;
  typedef elementlist_impl<const element> elementlist_const;


  class choice : public element {
  protected:
    typedef std::list<item> container;
    choice(const choice_info &info) : info_(info) {}
  public:
    typedef container::iterator iterator;
    typedef container::const_iterator const_iterator;

    virtual ~choice();

    virtual bool is_equal_to(const element *element) const;
    virtual void copy_to(element *element) const;


    iterator begin() { return items_.begin(); }
    iterator end() { return items_.end(); }
    const_iterator begin() const { return items_.begin(); }
    const_iterator end() const { return items_.end(); }

    iterator find_iterator(element *item);

    iterator erase(iterator it);
    iterator erase(iterator first, iterator last);
    void insert(iterator it, element *elm, const name &qname);
    void insert(iterator it, element *elm, const std::string &rawname);
    void insert(element *pos , element *elm, const name &qname);
    void insert(element *pos, element *elm, const std::string &rawname);
    void push_back(element * item, const name &qname);
    void push_back(element * item, const std::string &rawname);

    size_t size() const;
    void get_elementlist(const std::string &tagname, elementlist& el);
    void get_elementlist(const std::string &tagname, elementlist_const& el) const;



    void clear();
    void delete_and_clear();
    
    // Type identifier-related members.
    virtual baseclass_id get_baseclass_id() const;
    virtual const choice_info &get_choice_info() const;
  protected:
    template<class E>
    void get_elementlist_impl(const name& name, E &el) { 
      for (container::iterator it = items_.begin(); it != items_.end(); ++it)
        if (it->get_qname() == name)
          el.push_back(static_cast<typename E::element_type*>(it->get_element()));
    }

    template<class E>
    void get_elementlist_impl(const name& name, E &el) const { 
      typedef typename E::element_type element_type;
      for (container::const_iterator it = items_.begin(); it != items_.end(); ++it)
        if (it->get_qname() == name)
          el.push_back(static_cast<const element_type*>(it->get_element()));
    }

  protected:
    container items_;
    const choice_info &info_;
  };


  class choice_info {
    typedef std::map<name, const itemtype*, name_less> itemtype_map;
  public:
    typedef itemtype_map::iterator iterator;
    typedef itemtype_map::const_iterator const_iterator;
    
    void register_itemtype(const itemtype *info);
    
    const_iterator begin() const{
      return itemtypes_.begin();
    }
    const_iterator end() const{
      return itemtypes_.end();
    }
    const_iterator find(const name &qname) const {
      return itemtypes_.find(qname);
    }

    void initialize_instance(choice &cho) const;
    bool is_equal(const choice &cho1, const choice &cho2) const;
    void copy(choice &dst, const choice &src) const;

    void clear();
  protected:
    itemtype_map itemtypes_;
  };




}


#endif
