#include "document.h"

using namespace akaxiso;

document::~document() {
  delete element_;
}



void document_factory::register_document_type(const name &name, document_creator creator){
  doctype_map_.insert(doctype_map::value_type(name, creator));
}

document *document_factory::create_named_document(const name &name){
  doctype_map::iterator it = doctype_map_.find(name);
  if (it == doctype_map_.end()) {
    std::string errmsg = "Document(" + name.get_name() + ") not found.";
    throw parse_exception(__FILE__, __LINE__, errmsg.c_str());
  }
  return it->second();
}

document_factory::doctype_map document_factory::doctype_map_;
