#include "name.h"
#include "namespaces.h"
#include <assert.h>

using namespace akaxiso;

void name::set_name(const std::string &uri, const std::string &name) {
  uri_id_ = namespaces().register_namespace_uri(uri);
  name_ = name;
}


void name::set_localname(const std::string &name) {
  uri_id_ = empty_token;
  name_ = name;
}

const std::string &name::get_name() const{
  if (uri_id_ == unregistered_token) {
    cache_ = "";
    return cache_;  
  }
  if (is_qualified()) {
    const global_attributes &gattrs = static_global_attributes(); 
    cache_ = gattrs.get_prefix_map().get_prefix(uri_id_) + ':' + name_;
    return cache_;
  }
  else
    return name_;
}

const std::string &name::get_localname() const {
  return name_;
}


void name::set_name(const std::string &rawname) {
  set_name(rawname, static_global_attributes());
}

void name::set_name(const std::string &rawname, const global_attributes &gattrs) {

  std::string::size_type pos = rawname.find_first_of(':');

  if (pos == std::string::npos) { // local, not qualified.
    uri_id_ = empty_token;
    name_ = rawname;
  }
  else {
    std::string prefix = rawname.substr(0, pos);
    uri_id_ = gattrs.get_prefix_map().get_prefix_id(prefix);
    if (uri_id_ == unregistered_token)
      throw invalid_argument();
    name_ = rawname.substr(pos + 1, rawname.length() - pos);
  }
}

bool name::empty() const {
  assert((uri_id_ != unregistered_token) || (name_.empty()));
  if (uri_id_ == unregistered_token)
    return true;
  return (name_.empty());
}
