#include "membertypes.h"
#include "sequence.h"

using namespace akaxiso;


baseclass_id sequence::get_baseclass_id() const {
  return sequence_id;
}


void sequence_info::register_memberinfo(member_info &desc) {
  member_infos_.push_back(desc);
}


void sequence_info::clear() {
  for (member_info_array::iterator it = member_infos_.begin();
       it != member_infos_.end(); ++it)
    it->clear();
  member_infos_.clear();
}


bool sequence_info::is_equal(const sequence & sequence1, const sequence &sequence2) const{
  for (member_info_array::const_iterator cit = member_infos_.begin();
       cit != member_infos_.end(); ++cit) {
    bool b = cit->get_member_operator().is_equal(sequence1, sequence2);
    if (!b)
      return false;
  }
  return true;
}


void sequence_info::copy(sequence & dst, const sequence &src) const {
   for (member_info_array::const_iterator cit = member_infos_.begin();
       cit != member_infos_.end(); ++cit) 
    cit->get_member_operator().copy(dst, src);
}


void sequence_info::initialize_instance(sequence &seq) const {
   for (member_info_array::const_iterator cit = member_infos_.begin();
       cit != member_infos_.end(); ++cit) 
    cit->get_member_operator().initialize_instance(seq);
}
