// -*- c++ -*-
#ifndef AKAXISO_SEQUENCE_H__
#define AKAXISO_SEQUENCE_H__

#include <akaxiso/classes/memberinfo.h>
#include <akaxiso/classes/element.h>
#include <vector>

namespace akaxiso {

  class sequence_info;
  class attribute_info;

  class sequence : public element {
  public:
    virtual baseclass_id get_baseclass_id() const;
    virtual const sequence_info &get_sequence_info() const = 0;
  };



  class sequence_info {
    typedef std::vector<member_info> member_info_array;
  public:
    typedef member_info_array::iterator iterator;
    typedef member_info_array::const_iterator const_iterator;
    void register_memberinfo(member_info &info);

    const_iterator begin() const {
      return member_infos_.begin();
    }
    const_iterator end() const {
      return member_infos_.end();
    }

    void initialize_instance(sequence &seq) const;
    bool is_equal(const sequence & sequence1, const sequence &sequence2) const;
    void copy(sequence & dst, const sequence &src) const;

    void clear();

  private:
    member_info_array member_infos_;
  };


}

#endif
