/* -*- c++ -*- */
#ifndef AKAXISO_SIMPLECONTENT_IMPL_H__
#define AKAXISO_SIMPLECONTENT_IMPL_H__

#include <akaxiso/classes/simplecontent.h>
#include <akaxiso/classes/membertypes.h>
#include <akaxiso/classes/base_impl.h>

namespace akaxiso {

  template<class T, class V>
  class simplecontent_impl : public simplecontent, public base_impl<T> {
  public:
    typedef T finalclass;

    void write_text(std::ostream &ostm, const global_attributes &gattrs) const;
    bool read_text(std::istringstream &istm, const global_attributes &gattrs);

    virtual bool is_equal_to(const element *element) const;
    virtual void copy_to(element *element) const;
    virtual const typeinfo &get_typeinfo() const;
    virtual element *replicate_element() const;

    virtual const attribute_info &get_attribute_info() const;

    T *replicate() const;

    static void initialize();
    static void uninitialize();
    static T* create();


    V value_;


    static attribute_info &static_attribute_info() { return attribute_info_; } 
    static simpletype_member_type &static_value_type() { return *value_type_; }
  protected:
    static typeinfo &static_typeinfo() { return type_info_; }
  private:
    static typeinfo type_info_;
    static attribute_info attribute_info_;
    static simpletype_member_type *value_type_;
  };

  template<class T, class V>
  typeinfo simplecontent_impl<T, V>::type_info_;

  template<class T, class V>
  simpletype_member_type* simplecontent_impl<T, V>::value_type_;

  template<class T, class V>
  attribute_info simplecontent_impl<T, V>::attribute_info_;
  
  template<class T, class V>
  void simplecontent_impl<T, V>::write_text(std::ostream &ostm, const global_attributes &gattrs) const {
    value_type_->write_text(*this, ostm, gattrs);
  }

  template<class T, class V>
  bool simplecontent_impl<T, V>::read_text(std::istringstream &istm, const global_attributes &gattrs) {
    value_type_->read_text(*this, istm, gattrs);
    return true;
  }


  template<class T, class V>
  const attribute_info &simplecontent_impl<T, V>::get_attribute_info() const {
    return attribute_info_;
  }


  template<class T, class V>
  const typeinfo &simplecontent_impl<T, V>::get_typeinfo() const {
    return type_info_;
  }

  template<class T, class V>
  T* simplecontent_impl<T, V>::replicate() const {
    T* t = create();
    copy_to(t);
    return t;
  }

  template<class T, class V>
  bool simplecontent_impl<T, V>::is_equal_to(const element *element) const {
    if (& get_typeinfo() != & element->get_typeinfo())
      return false;
    return value_type_->is_equal(*this, *element) &&
      attribute_info_.is_equal(*this, *element);
  }  

  template<class T, class V>
  void simplecontent_impl<T, V>::copy_to(element *element) const {
    if (& get_typeinfo() != & element->get_typeinfo())
      throw invalid_argument();
    value_type_->copy(*element, *this);
    attribute_info_.copy(*element, *this);
  }  

  template<class T, class V>
  void simplecontent_impl<T, V>::initialize() {
//      T::register_to_factory();
    akaxiso::member_info meminfo; \
    value_type_ = static_cast<simpletype_member_type*>(create_member_operator((T*)0, &T::value_));
    T::initialize_types();
  }
  
  template<class T, class V>
  void simplecontent_impl<T, V>::uninitialize() {
    attribute_info_.clear();
  }

  template<class T, class V>
  T* simplecontent_impl<T, V>::create() {
    T* t = new T;
    value_type_->initialize_instance(*t);
    attribute_info_.initialize_instance(*t);
    return t;
  }

  template<class T, class V>
  element *simplecontent_impl<T, V>::replicate_element() const {
    return replicate();
  }




  template<class T>
  class simplecontent_member_type_impl : public simplecontent_member_type {
  public:
    simplecontent_member_type_impl(int offset) : simplecontent_member_type(offset) {}
    virtual bool is_equal(const element &seq1, const element &seq2) const;
    virtual void copy(element &dst, const element &src) const;
    virtual void initialize_instance(element &seq) const;
    virtual baseclass_id get_baseclass_id() const;

  };

  template<class T>
  bool simplecontent_member_type_impl<T>::is_equal(const element &seq1, const element &seq2) const {
    const T* t1 = get_member_ptr<const T>(seq1, offset_);
    const T* t2 = get_member_ptr<const T>(seq2, offset_);
    return t1->is_equal_to(t2);
  }

  template<class T>
  void simplecontent_member_type_impl<T>::copy(element &dst, const element &src) const {
    T* tdst = get_member_ptr<T>(dst, offset_);
    const T* tsrc = get_member_ptr<const T>(src, offset_);
    tsrc->copy_to(tdst);
  } 

  template<class T>
  void simplecontent_member_type_impl<T>::initialize_instance(element &element) const {
    T& tdst = *get_member_ptr<T>(element, offset_);
    T::static_attribute_info().initialize_instance(tdst);
  }

  template<class T>
  baseclass_id simplecontent_member_type_impl<T>::get_baseclass_id() const {
    return simplecontent_id;
  }



}


#endif
