// -*- c++ -*-
#ifndef AKAXISO_NAMESPACE_MAP_H__
#define AKAXISO_NAMESPACE_MAP_H__

#include <akaxiso/classes/types.h>
#include <map>

namespace akaxiso {

  typedef long id_type;
  extern const id_type unregistered_token;
  extern const id_type empty_token;

  class tokenmap {
    typedef std::map<id_type, std::string> tokens;
    typedef std::map<const std::string, id_type> ids;

  public:
    tokenmap() : current_id_(1){}
    id_type register_and_get_id(const std::string &uri);
    id_type get_id(const std::string &uri) const;
    const std::string &get_token(const id_type id) const;
  private:
    id_type current_id_;
    tokens tokens_;
    ids ids_;

  public:
    void initialize();
    void uninitialize();
  };

  class tokenassociation {
    typedef std::map<id_type, std::string> tokens;
    typedef std::map<const std::string, id_type> ids;

  public:
    tokenassociation(){}
    void associate(const id_type id, const std::string &token);
    id_type get_id(const std::string &token) const;
    const std::string &get_token(const id_type id) const;
  
    typedef tokens::const_iterator const_iterator;
    const_iterator begin() const { return tokens_.begin(); }
    const_iterator end() const { return tokens_.end(); }

  private:
    tokens tokens_;
    ids ids_;

  public:
    void initialize();
    void uninitialize();
  };

}

#endif
