// -*- c++ -*-
#ifndef AKAXISO_TYPEDESC_H__
#define AKAXISO_TYPEDESC_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/namespaces.h>
#include <akaxiso/classes/name.h>

namespace akaxiso {

  class typeinfo {
  public:
    void set_typename(const std::string &name) {
      name_.set_name(name);
    }
    void set_typename(const std::string uri, const std::string &name) {
      name_.set_name(uri, name);
    }
    const std::string &get_typename() const {
      return name_.get_name();
    }
    const std::string &get_uri() const;
    id_type get_uri_id() const;
  private:
    name name_;
    mutable std::string uri_;
  };
}

#endif
