#include "attribute_handler.h"
#include "../classes/attributeinfo.h"
#include "../classes/memberinfo.h"
#include "../classes/membertypes.h"
#include "../classes/attribute_membertype.h"

#include <sstream>

using namespace akaxiso;

void akaxiso::parse_attributes(element &elm, const attributes &attrs, const global_attributes &gattrs) {

  const attribute_info &info = elm.get_attribute_info();
  for (attribute_info::const_iterator it = info.begin();
       it != info.end(); ++it) {
    attributes::const_iterator itattr = attrs.find(it->get_localname());
    if (itattr == attrs.end()) 
      continue;

    std::istringstream istm(itattr->second);
    static_cast<const attribute_member_type&>(it->get_member_operator()).read_text(elm, istm, gattrs);
  }

}
