#include "choice_handler.h"
#include "sequence_handler.h"
#include "simplecontent_handler.h"
#include "../classes/choice.h"
#include "../classes/simplecontent.h"

#include <cassert>

using namespace akaxiso;
  
choice_handler::choice_handler(choice *cho, handlers &handlers, const locator *locator) 
  : handler(handlers, locator), cho_(cho), info_(cho->get_choice_info()){
}


void choice_handler::query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs) {
  choice_info::const_iterator it = info_.find(qname);
  if (info_.end() == it)
    throw parse_exception(__FILE__, __LINE__, locator_->get_position());
  
  qname_ = qname;

  element *e = it->second->create_element();

  handler *handler = NULL;
  switch (e->get_baseclass_id()) {
  case sequence_id: {
    handler = new sequence_handler(static_cast<sequence*>(e), handlers_, locator_);
    break;
  }
  case choice_id: {
    handler = new choice_handler(static_cast<choice*>(e), handlers_, locator_);
    break;
  }
  case simplecontent_id: {
    handler = new simplecontent_handler(static_cast<simplecontent*>(e), handlers_, locator_);
    break;
  }
  case simpletype_id:
  default:
    assert(!"Must not reach here.");
  }

  handlers_.push(handler);
}

void choice_handler::prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs){
}


void choice_handler::end_element(const name &qname) {
}


void choice_handler::parse_entity(const std::string &entity) {
  
}

element* choice_handler::get_element() {
  return cho_;
}

void choice_handler::receive_child(element *e) {
  cho_->push_back(e, qname_);
}

bool choice_handler::rollup() const {
  return false;
} 
