// -*- c++ -*-
#ifndef AKAXISO_CHOICE_HANDLER_H__
#define AKAXISO_CHOICE_HANDLER_H__

#include <akaxiso/parser/handler.h>

namespace akaxiso {
  class choice;
  class choice_info;
  
  class choice_handler : public handler {
  public:
    choice_handler(choice *cho, handlers &handlers, const locator *locator);
    virtual ~choice_handler(){}
    virtual void query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs);
    virtual void prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs);
    virtual void end_element(const name &qname);
    virtual void parse_entity(const std::string &entity);
    virtual bool rollup() const;

    virtual element *get_element();
    virtual void receive_child(element *e);

  private:
    choice *cho_;
    const choice_info &info_;
    name qname_;
  };

}

#endif

