// -*- c++ -*-
#ifndef CDOM_XERCESC_DOCUMENTHANDLER_H__
#define CDOM_XERCESC_DOCUMENTHANDLER_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/parser/handler.h>
#include <akaxiso/parser/attributes.h>


namespace akaxiso {

  class name;
  class locator;
  class document;

  
  class document_handler {
  public:
    document_handler();
    ~document_handler();

    void startElement(const name &qname, const attributes& attrs);
    void characters(const char* chars, const unsigned int length);
    void endElement(const name &qname);
    void set_locator(const locator* const locator);
    document *adopt_document();
    const handler::handlers &get_handlers() const {
      return handlers_;
    }

    void start_prefix_mapping(const std::string &prefix, const std::string &uri);
    void end_prefix_mapping(const std::string &prefix);

    global_attributes &get_global_attributes() {
      return gattrs_;
    }

  protected:
    std::string charsbuf_;
    handler::handlers handlers_;
    global_attributes gattrs_;
    document *doc_;
    const locator *locator_;
  };

}

#endif

