// -*- c++ -*-
#ifndef AKAXISO_HANDLER_H__
#define AKAXISO_HANDLER_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/name.h>
#include <akaxiso/classes/global_attributes.h>
#include <akaxiso/parser/attributes.h>
#include <akaxiso/parser/locator.h>

#include <stack>

namespace akaxiso {
  class element;

  struct handler {
    typedef std::stack<handler*> handlers;
    virtual void query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs) = 0;
    virtual void prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs) = 0;
    virtual void end_element(const name &qname) = 0;
    virtual bool rollup() const = 0;

    // Mainly used by simpletypes.
    virtual void parse_entity(const std::string &entity) = 0;

    // Mainly used for choices.
    virtual element *get_element() = 0;
    virtual void receive_child(element *e) = 0;

 protected:
    handler(handlers &handlers, const locator *locator) : handlers_(handlers), locator_(locator){}
    handlers &handlers_;
    const locator *locator_;
  };

}



#endif
