#include "simpletype_handler.h"
#include <cassert>
#include <sstream>

using namespace akaxiso;


simpletype_handler::simpletype_handler(element *e, 
				       const simpletype_member_type &smt, 
				       handlers &handlers,
				       const locator *locator) 
  : handler(handlers, locator), elm_(e), smt_(smt) {}


void simpletype_handler::query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs) {
  assert(!"Must not be called.");
}

void simpletype_handler::prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs) {
  gattrs_ = &gattrs;
}


void simpletype_handler::end_element(const name &qname){
}

void simpletype_handler::parse_entity(const std::string &entity) {
  std::istringstream istm(entity);
  smt_.read_text(*elm_, istm, *gattrs_);
}


// Mainly used for choices.
element *simpletype_handler::get_element(){
  return NULL;
}

void simpletype_handler::receive_child(element *e){
  assert(!"Must not be called.");
}

bool simpletype_handler::rollup() const {
  return false;
}
