// -*- c++ -*-
#ifndef AKAXISO_SIMPLETYPE_HANDLER_H__
#define AKAXISO_SIMPLETYPE_HANDLER_H__

#include <akaxiso/classes/membertypes.h>
#include <akaxiso/classes/simpletype.h>
#include <akaxiso/parser/handler.h>

namespace akaxiso {

  class simpletype_handler : public handler {
  public:
    simpletype_handler(element *cho, const simpletype_member_type &smt, handlers &handlers, const locator *locator);
    virtual ~simpletype_handler(){}
    virtual void query_element(const name &qname, const attributes &attrs, const global_attributes &gattrs);
    virtual void prepare_element(const name &qname, const attributes &attrs, const global_attributes &gattrs);
    virtual void end_element(const name &qname);
    virtual bool rollup() const;

    virtual void parse_entity(const std::string &entity);

    // Mainly used for choices.
    virtual element *get_element();
    virtual void receive_child(element *e);

  private:
    element *elm_;
    const simpletype_member_type &smt_;
    const global_attributes *gattrs_;
  };

}

#endif

