// -*- c++ -*-
#ifndef AKAXISO_XML_SERIALIZER_H__
#define AKAXISO_XML_SERIALIZER_H__

#include <akaxiso/classes/types.h>
#include <akaxiso/classes/classes.h>
#include <akaxiso/serializer.h>

namespace akaxiso {
  
  class xmlserializer : public serializer {
  public:
    xmlserializer(const std::string &encoding = "UTF-8") : encoding_(encoding){};
    virtual void serialize(const document *doc, std::ostream &ostm);
  private:
    void write_element(const element *element, const std::string &tagname, std::ostream &ostm);
    void open_beginning_tag(const std::string &tagname, std::ostream &ostm);
    void close_beginning_tag(std::ostream &ostm);
    void write_ending_tag(const std::string &tagname, std::ostream &ostm);
    void write_entity(const element* e, std::ostream &ostm);
    void write_attributes(const element *elm, std::ostream &ostm);

    void write_namespace_attributes(std::ostream &ostm);

    static void escape_attribute_value(const std::string &value, std::ostream &ostm);
    static void escape_text_value(const std::string &value, std::ostream &ostm);

    std::string encoding_;

  };

}


#endif




