#include "ygg_parser.h"
#include "ygg_handler.h"

#include <yggdrasil/ygg.h>
#include <sstream>

using namespace akaxiso;
namespace ygg = yggdrasil;

document *ygg_parser::parse_stdin(){
  return parse(std::cin);
}


document *ygg_parser::parse(const char *buff){
  std::istringstream istm(buff);
  return parse(istm);
}


document *ygg_parser::parse(const std::string& document){
  std::istringstream istm(document);
  return parse(istm);
}


document *yggsox_parser::parse(std::istream &istm) {
  ygg_handler *handler = new ygg_handler;
  ygg::sox_stream().read(istm, handler);
  document *document = handler->adopt_document();
  delete handler;
  return document;
}


document *yggxml_parser::parse(std::istream &istm) {
  ygg_handler *handler = new ygg_handler;
  ygg::xml_stream().read(istm, handler);
  document *document = handler->adopt_document();
  delete handler;
  return document;
}

