#include "platform.h"
#include "classcontents.h"
#include "exception.h"
#include <assert.h>

using namespace osixaka;


bool class_contents_container::exists(const akaxiso::name &name) const {
  contents::const_iterator it = contents_.find(name);
  return !(it == contents_.end());
}

void class_contents_container::add(const akaxiso::name &name, class_contents *contents) {
  contents->name_ = name;
  std::pair<class_contents_container::contents::iterator, bool> res = 
    contents_.insert(class_contents_container::contents::value_type(name, contents));
  if (!res.second)
    throw fatal_error(__FILE__, __LINE__, "Dupulicated class name. (Maybe internal error)");
}

class_contents *class_contents_container::get(const akaxiso::name &name){
  contents::iterator it = contents_.find(name);
  if (it == contents_.end())
    return NULL;
  return it->second;
}

void simplecontent_class::generate_header(std::ostream &ostm) const {
  const std::string &classname = name_.get_name();
  
  ostm << "/** " << classname << " */" << std::endl;

  ostm << "class " << classname << " : public akaxiso::simplecontent_impl<" 
       << classname << ',' << value_type_ << "> {" << std::endl
       << "public:" << std::endl
       << "  static void initialize_types();" << std::endl
       << "};" << std::endl
       << std::endl;
}

void simplecontent_class::generate_implementation(std::ostream &ostm) const {

  const std::string &classname = name_.get_name();
  
  ostm << "void " << classname << "::initialize_types() {" << std::endl
       << "  static_typeinfo().set_typename(\"" << classname << "\");" << std::endl
       << "}" << std::endl
       << std::endl;
}

void sequence_class::generate_header(std::ostream &ostm) const {

  const std::string &classname = name_.get_name();
  ostm << "class " << classname << " : public akaxiso::sequence_impl<" << classname << "> {" << std::endl
       << "public:" << std::endl
       << "  static void initialize_types();" << std::endl
       << std::endl;

  for (sequence_members::const_iterator it = members_.begin(); it != members_.end(); ++it) 
    if (!it->is_array())
      ostm << "  " << it->type_ << " " << it->name_ << "_;" << std::endl;
    else {
      ostm << "  typedef akaxiso::memberarray_impl<" << it->type_ << "> "  // array typedef
	   << it->type_ << "s_type;" << std::endl // array typename
	   << "  " << it->type_ << "s_type " << it->name_ << "s_;" << std::endl;
    }

  ostm << "};" << std::endl
       << std::endl;
}

void sequence_class::generate_implementation(std::ostream &ostm) const {

  const std::string &classname = name_.get_name();
  ostm << "void " << classname << "::initialize_types() {" << std::endl
       << "  static_typeinfo().set_typename(\"" << classname << "\");" << std::endl
       << std::endl;

  for (sequence_members::const_iterator it = members_.begin(); it != members_.end(); ++it)
    if (!it->is_array())
      ostm << "  define_member(\"" << it->name_ << "\", &" << classname << "::" << it->name_ << "_);" << std::endl;
    else {
      ostm << "  define_member(\"" << it->name_ << "\", &" << classname << "::" << it->name_ << "s_);"
	   << "// OCCURENCE(" << it->minOccurs_ << ", "; 
      if (it->maxOccurs_.is_unbounded())
	ostm << "akaxiso::unbounded";
      else
	it->maxOccurs_.write_text(ostm); 
      ostm << ")" << std::endl;
    }
  
  ostm << std::endl
       << "};" << std::endl
       << std::endl;

}

void choice_class::generate_header(std::ostream &ostm) const {

  const std::string &classname = name_.get_name();
  ostm << "class " << classname << " : public akaxiso::choice_impl<" << classname << "> {" << std::endl
       << "public:" << std::endl
       << "  static void initialize_types();" << std::endl
       << std::endl;

  for (choice_items::const_iterator it = items_.begin(); it != items_.end(); ++it) 
    ostm << "  struct tag" << it->name_ 
	 << " : public akaxiso::itemtype_impl<tag" << it->name_ << ", " << it->type_ << "> {" << std::endl
	 << "    const char *get_tagname() const { return \"" << it->name_ << "\"; }" << std::endl
	 << "  };" << std::endl
	 << std::endl;

  ostm << "};" << std::endl
       << std::endl;

}

void choice_class::generate_implementation(std::ostream &ostm) const {

  const std::string &classname = name_.get_name();
  ostm << "void " << classname << "::initialize_types() {" << std::endl
       << "  static_typeinfo().set_typename(\"" << classname << "\");" << std::endl
       << std::endl;

  for (choice_items::const_iterator it = items_.begin(); it != items_.end(); ++it) {
    ostm << "  define_item(tag" << it->name_ << "());" << std::endl;
  }

  ostm << "}" << std::endl
       << std::endl;

}

void class_contents_container::remove_class_contents(const class_contents *content) {
  contents::iterator it = contents_.find(content->name_);
  assert(it != contents_.end());

  for (contents::iterator cit = contents_.begin(); cit != contents_.end(); ++cit)
    cit->second->remove_dependency(it->second->name_.get_name());

  delete it->second;
  contents_.erase(it);
}

void document_class::generate_header(std::ostream &ostm) const {
  ostm << "class " << name_.get_name() 
       << " : public akaxiso::document_impl<" << name_.get_name() << ", " <<  root_name_ << "> {" << std::endl
       << "public:" << std::endl
       << "  static void initialize_types();" << std::endl
       << "};" << std::endl 
       << std::endl;
}

void document_class::generate_implementation(std::ostream &ostm) const {

  ostm << "void " << name_.get_name() << "::initialize_types() {" << std::endl
       << "  define_document(\"" << root_name_ << "\");" << std::endl
       << "}" << std::endl
       << std::endl;
}

