#include <akaxiso/akaxiso.h>
#include "setup.h"
#include <iostream>

int main(int argc, char* argv[]){
  
  // Initialize Xerces.
  akaxiso::initialize();
  // Initialize Document classes.
  ::initialize();

  // Parse
  akaxiso::yggxml_parser parser;

  akaxiso::document *doc = NULL;
  try {
    doc = parser.parse_stdin();
  }
  catch (const akaxiso::parse_exception &e) {
    std::cerr << e.what() << std::endl;
    std::cerr << "Parse error detected.  Abort immediately." << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Unhandled parse error detected.  Abort immediatedly." << std::endl;
    exit(1);
  }

  std::cerr << "Document root tag is " << doc->get_root_tagname().get_name() << "." << std::endl;
  /*
    Get the root node of document.
    YourDoc *ydoc = static_cast<YourDoc*>(doc->get_root());
  */

  akaxiso::xmlserializer ser;
  ser.serialize(doc, std::cout);

  delete doc;

  // Uninitializers.
  ::uninitialize(); // Uninitialize document classes.
  akaxiso::uninitialize();

  return 0;
}
