// -*- c++ -*-
#ifndef PROJECT_H__
#define PROJECT_H__

#include <akaxiso/akaxiso.h>

namespace pj {

  struct cuppa{
    const char *prefix() const { return "cuppa";}
    const char *uri() const { return "http://unittest.org/akaxiso/memberlist";}
  };

  class Member : public akaxiso::sequence_impl<Member> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("cuppa:member");
      define_member("name", &Member::name_);
      define_member("title", &Member::title_);
    }

    std::string name_;
    std::string title_;

  };



  class Members : public akaxiso::choice_impl<Members> {
  public:
    static void initialize_types() {
      static_typeinfo().set_typename("cuppa:members");
      define_item(member());
    }
    struct member : public akaxiso::itemtype_impl<member, Member> { const char *get_tagname() const{ return "cuppa:member"; } };
  };

  class Team : public akaxiso::sequence_impl<Team> {
    public:
    static void initialize_types() {
      static_typeinfo().set_typename("cuppa:team");
      define_member("cuppa:project_name", &Team::name_);
      define_member("cuppa:url", &Team::url_);
      define_member("cuppa:members", &Team::members_);
    }

    std::string name_;
    std::string url_;
    Members members_;
  };


  class Project : public akaxiso::document_impl<Project, Team> {
  public:
    static void initialize_types() {
      define_document("cuppa:project");
    }
  };

  void initialize();
  void uninitialize();

}



#endif
