#include <config.h>

#include <akaxiso/akaxiso.h>
#include "project.h"


static void usage() {
  std::cout << "Serialization sample (" << PACKAGE << "-" << VERSION << ")" << std::endl
	    << " options" << std::endl
	    << "  --xml : Serialized in XML." << std::endl
	    << "  --sox : Serialized in SOX." << std::endl
	    << "  --help(-h) : Show this message." << std::endl;
}



int main(int argc, const char* argv[]){
  
  akaxiso::initialize();
  // Initialize Project classes defined in project.h.
  pj::initialize();
  
  // Create Document instance.
  pj::Project *memberlist = pj::Project::create();
  // Get the root node.
  pj::Team *team = memberlist->get_root();

  pj::Members &members= team->members_;

  pj::Member *member;

  team->name_ = "Cuppa project team";
  team->url_ = "http://unittest.org";

  // Set values

  member = pj::Member::create();
  member->name_ = "Episteme";
  member->title_ = "God of dragon";
  // append a Member instance to Members.
  members.push_back(member, "cuppa:member");

  member = pj::Member::create();
  member->name_ = "Shibukawa";
  member->title_ = "Artistic director";
  members.push_back(member, "cuppa:member");

  member = pj::Member::create();
  member->name_ = "Doukeshi";
  member->title_ = "Wraith of the trickstar";
  members.push_back(member, "cuppa:member");

  member = pj::Member::create();
  member->name_ = "Ahiru";
  member->title_ = "BCB guru";
  members.push_back(member, "cuppa:member");

  member = pj::Member::create();
  member->name_ = "Ueno";
  member->title_ = "Emacs Maestro";
  members.push_back(member, "cuppa:member");

  member = pj::Member::create();
  member->name_ = "Tomohiro Yoshida";
  member->title_ = "What would you like to be?";
  members.push_back(member, "cuppa:member");

  member = pj::Member::create();
  member->name_ = "shelarcy";
  member->title_ = "RELAX NG Evangelist";
  members.push_back(member, "cuppa:member");

  member = pj::Member::create();
  member->name_ = "Ando(&o)";
  member->title_ = "Sorcerer of macuppa";
  members.push_back(member, "cuppa:member");

  member = pj::Member::create();
  member->name_ = "Morino";
  member->title_ = "Farmer";
  members.push_back(member, "cuppa:member");

  akaxiso::serializer *ser = NULL;

  if (argc == 2) {
    std::string arg(argv[1]);
    if (arg == "--sox")
      ser = new akaxiso::soxserializer; 
    else if (arg == "--xml")
      ser = new akaxiso::xmlserializer;
    else if ((arg == "--help") || (arg == "-h")) {
      usage();
      exit(1);
    }
    else {
      std::cerr << "Unknown option" << std::endl;
      usage();
      exit(1);
    }
  }

  if (ser == NULL)
    ser = new akaxiso::xmlserializer;

  // Serialize.
  ser->serialize(memberlist, std::cout);
  
  delete memberlist;
  delete ser;

  pj::uninitialize();
  akaxiso::uninitialize();
  return 0;
}
