/*
	stdlib.h

	Borland include file for standard library definitions.
*/

/*
 *      C/C++ Run Time Library - Version 1.0
 *
 *      Copyright (c) 2002 by Borland Software Corporation
 *      All Rights Reserved.
 *
 */


#ifndef __STDLIB_H
#define __STDLIB_H

#ifndef ___DEFS_H
#include <_defs.h>
#endif

#include _STD_HEADER_(stdlib.h)

/* 
   GNU stdlib.h undefs/defs alloca so we
   redefine alloca after /usr/include/stdlib.h
*/
#undef alloca
void* __alloca__(size_t);
#define alloca(_x) __alloca__(_x)

#ifdef __cplusplus
extern "C" {
#endif

#ifndef __ARGV_DEFINED
#define __ARGV_DEFINED
extern int _argc;
extern char** _argv;
#define __argc _argc
#define __argv _argv
#endif

#ifndef __ENVIRON_DEFINED
#define __ENVIRON_DEFINED
extern char **__environ;
#define _environ __environ
#endif

#ifndef _MAX_PATH
#define _MAX_PATH 1024
#endif

void  _searchenv(const char * __file, const char * __varname, char *__pathname);
void  _searchstr(const char * __file, const char * __ipath, char *__pathname);
char *searchpath(const char *__file);

void _splitpath(const char * __path, char * __drive, char * __dir,
				char * __name, char * __ext);
void _makepath(char * __path, const char * __drive, const char * __dir,
				const char * __name, const char * __ext);

char *_fullpath(char * __buf, const char * __path, size_t __maxlen);

char *itoa(int __value, char * __string, int __radix);
char *ltoa(long __value, char * __string, int __radix);
char *utoa (unsigned __value, char *__string, int __radix);
char *ultoa(unsigned long __value, char * __string, int __radix);
char *_ui64toa (unsigned __int64 __value, char *__string, int __radix);
char *_i64toa (__int64 __value, char *__string, int __radix);

#ifdef __cplusplus
} /* "C" */
#endif

#if !defined(__MINMAX_DEFINED)
#define __MINMAX_DEFINED
#undef min  /* make sure these aren't macros */
#undef max
#ifdef __cplusplus

extern "C++" {

namespace std {

/** Note: in C++ we implement min and max as template functions. */
template <class _T> inline const _T  &min( const _T &__t1, const _T &__t2 )
{
    if  (__t1 < __t2)
	return __t1;
    else
	return __t2;
}

template <class _T> inline const _T  &max( const _T  &__t1, const _T  &__t2 )
{
    if  (__t1 > __t2)
	return __t1;
    else
	return __t2;
}

/* #ifdef __BORLANDC__ */
/* using std::exit; */
/* #endif */

} /* namespace std */
} /* C++ */ 

using std::min;
using std::max;
#else /* __cplusplus */
#define max(__a,__b)    (((__a) > (__b)) ? (__a) : (__b))
#define min(__a,__b)    (((__a) < (__b)) ? (__a) : (__b))

#endif /* __cplusplus */
#endif /* __MINMAX_DEFINED */

#endif /* __STDLIB_H */
