/* -*- c++ -*- */
#ifndef AKAXISO_CLASSES_ANY_ATTRIBUTES_H__
#define AKAXISO_CLASSES_ANY_ATTRIBUTES_H__

#include <akaxiso/classes/qname.h>
#include <vector>
#include <assert.h>

namespace aka2 {

  /** Wildcard attribute class */
  struct wc_attribute {
    wc_attribute(){}
    wc_attribute(const qname &tagname, const std::string &value) 
      : tagname_(tagname), value_(value) {}
    qname tagname_;
    std::string value_;
  };
  typedef std::vector<wc_attribute> wc_attributes;

  class any_attributes_op : public element_op {
  public:
    virtual schematype_id get_schematype() const { return any_attribute_id; }
    virtual const qname& get_typename() const { 
      if (typename_.qualified().empty())
	typename_ = qname("xs:anyAttribute");  /** !!!!!! */
      return typename_;
    }
    
    /** creatable */
    virtual void* create() const { return 0; }
    virtual void destroy(void *elm) const { assert(!"Must not be called."); }
    virtual bool equals(const void *lhs, const void *rhs) const;
    virtual void copy(void *dest, const void *src) const;
    
    /** attribute_info getter. */
    virtual const attribute_types *get_attribute_types() const { 
      assert(!"Must not be called.");
      return 0; 
    }
    virtual const any_member *get_anyattr_type() const {
      assert(!"Must not be called.");
      return 0; 
    }

    static any_attributes_op dispatcher_;
    static qname typename_;
  };


}

#endif
