// -*- c++ -*-
#ifndef AKAXISO_TYPES_H__
#define AKAXISO_TYPES_H__

#include <akaxiso/configuration.h>
#include <akaxiso/exception.h>

/** akaxiso data model namespace */
namespace aka2 {

  class namespace_map;
  class global_attributes;
  class document_factory;
  class type_registory;

  namespace_map &namespaces();
  global_attributes &system_global_attributes();
  document_factory &system_document_factory();
  type_registory &system_type_registory();


  enum schematype_id {
    simpletype_id = 1,
    simplecontent_id,
    array_id,
    sequence_id,
    choice_id,
    all_id,
    ptrmember_id,
    enclose_id,
    disclose_id,
    any_id,
    any_array_id,
    any_attribute_id,
    fixed_id
  };

  struct attribute_types;
  class any_member; 
  class qname;

  /** Element */
  struct element_op {
    virtual ~element_op() {}
    virtual schematype_id get_schematype() const = 0;
    virtual const qname& get_typename() const = 0;
    virtual void* create() const = 0;
    virtual void destroy(void *) const = 0;
    virtual bool equals(const void *lhs, const void *rhs) const = 0;
    virtual void copy(void *dest, const void *src) const = 0;
    virtual const attribute_types *get_attribute_types() const = 0;
    virtual const any_member *get_anyattr_type() const = 0;

    void *replicate(const void *src) const {
      void *dest = create();
      copy(dest, src);
      return dest;
    }
  };

} // namespace aka2

/** XML typeinfo namespace */
namespace xiso {
  template<class T> struct leaf;
}

/** version-independent alias namespace for aka2. */
namespace aka = aka2;

#endif /* AKAXISO_TYPES_H__ */
