#include "any_attributes.h"

using namespace aka2;

bool any_attributes_op::equals(const void *lhs, const void *rhs) const {
  const wc_attributes& lattrs = *static_cast<const wc_attributes*>(lhs);
  const wc_attributes& rattrs = *static_cast<const wc_attributes*>(rhs);

  if (lattrs.size() != rattrs.size())
    return false;
  
  wc_attributes::const_iterator lit = lattrs.begin();
  wc_attributes::const_iterator rit = rattrs.begin();

  while ((lattrs.end() != lit) && (rattrs.end() != rit)) {
    bool res = (lit->name_ == rit->name_) &&
      (lit->value_ == rit->value_);
    if (!res)
      return false;
    ++lit;
    ++rit;
  }
  assert((lattrs.end() == lit) && (rattrs.end() == rit));
  return true;
}

any_attributes_op any_attributes_op::dispatcher_;
qname any_attributes_op::typename_;

