/* -*- c++ -*- */
#include "builtin.h"

#ifdef _MSC_VER

#include <iostream>

std::istream &operator >>(std::istream &istm, LONGLONG &value) {
  char buf[256];
  istm.getline(buf, sizeof(buf));
  if (sscanf(buf, "%I64d", &value) != 1)
    throw aka::internal_error();
  return istm;
}

#endif /* _MSC_VER */


namespace xiso {

  void leaf<bool>::read_text(void *elm, std::istringstream &istm,
			     const aka2::global_attributes &gattrs) {
    bool &bval = *static_cast<bool*>(elm);
    const std::string &value = istm.rdbuf()->str();
    if ((value == "false") || (value == "0"))
      bval = false;
    else if ((value == "true") || (value == "1"))
      bval = true;
    else
      throw aka::internal_error();
  }


  void leaf<bool>::write_text(const void *elm, std::ostream &ostm,
			      const aka2::global_attributes &gattrs) {
    bool val = *static_cast<const bool*>(elm);
    if (val)
      ostm << "true";
    else
      ostm << "false";
  }

}
