/*  -*- c++ -*- */
#ifndef AKAXISO_CLASSES_FIXED_H__
#define AKAXISO_CLASSES_FIXED_H__

#include <akaxiso/classes/array.h>

namespace aka2 {

  template<class VL>
  struct fixed_dispatcher : public fixed_op {
    virtual const qname& get_typename() const {
      return VL::dispatcher_.get_typename();
    }
    virtual const simpletype_op& get_value_op() const {
      return VL::dispatcher_;
    }
  };

  template<class VL>
  struct fixed {
    static fixed_dispatcher<VL> dispatcher_;

    static default_op *create_default_op() { return VL::create_default_op(); }
    static void initialize() {}
    static void uninitialize() {}
  };

  template<class VL>
  fixed_dispatcher<VL> fixed<VL>::dispatcher_;


  /**
   * fixed_array.
   */
  template<class T, class VL=xiso::leaf<TYPENAME T::value_type> >
  struct fixed_sequential_array : public sequential_array<T, fixed<VL> > {  };

  template<class T, class VL=xiso::leaf<TYPENAME T::value_type> >
  struct fixed_associative_array : public associative_array<T, fixed<VL> > {  };

}

#endif
