/* -*- c++ -*- */
#ifndef AKAXISO_PTRMEMBER_H__
#define AKAXISO_PTRMEMBER_H__

#include <akaxiso/classes/traits.h>
#include <akaxiso/classes/deep_ptr.h>

namespace aka2 {

  template<class V, class VL>
  struct ptrmember_op_dispatcher : public ptrmember_op {
  public:
    virtual const qname& get_typename() const { return VL::typename_; }
    virtual const element_op& get_value_op() const {
      return VL::dispatcher_;
    };
    virtual void *&dereference(void *elm) const { 
      V &pv = *static_cast<V*>(elm);
      return reinterpret_cast<void*&>(pv.get());
    }
    virtual const void *dereference(const void *elm) const { 
      const V &pv = *static_cast<const V*>(elm);
      return pv.get();
    }

    static ptrmember_op_dispatcher<V, VL> dispatcher_;
  };

  template<class V, class VL>
  ptrmember_op_dispatcher<V, VL> ptrmember_op_dispatcher<V, VL>::dispatcher_;


}

#endif
