/* -*- c++ -*- */
#ifndef AKAXISO_PARSER_H__
#define AKAXISO_PARSER_H__

#include <string>
#include <iosfwd>

namespace aka2 {

  class global_attributes;
  struct document;

  class parser {
  public:
    parser() : gattrs_(0) {}
    virtual ~parser() {}
    virtual document parse(std::istream &istm) = 0;  
    virtual document parse(const char *document) = 0;
    virtual document parse(const std::string &document) = 0;
    virtual document parse_stdin() = 0;
    virtual document parse_file(const std::string &filename) = 0; 

    void set_gattrs(global_attributes& gattrs) {
      gattrs_ = &gattrs;
    }

  protected:
    global_attributes* gattrs_;
  };


#ifdef USE_XERCESC
  class xerces_parser;
  typedef xerces_parser xml_parser;
#else
  class yggxml_parser;
  typedef yggxml_parser xml_parser;
#endif

} // namespace aka2

#endif /* AKAXISO_PARSER_H__ */
